package img;

import java.awt.Color;
import img.io.ImageIO;

/**
 * Représente une image par un tableau de pixels.
 */
public class Image {

	/**
	 * Tableau de pixels.
	 */
	protected Color[][] pixels;

	/**
	 * Constructeur d'image à partir d'un tableau de pixels.
	 * 
	 * @param pixels pixels de l'image
	 */
	public Image(Color[][] pixels) {
		this.pixels = pixels;
	}

	/**
	 * Constructeur d'image à partir d'un fichier.
	 * 
	 * @param fichier nom du fichier image à charger
	 */
	public Image(String fichier) {
		this.pixels = ImageIO.load(fichier);
	}

	/**
	 * Sauvegarde de l'image dans un fichier.
	 * 
	 * @param fichier nom fichier à créer ou à mettre à jour
	 */
	public void save(String fichier) {
		ImageIO.save(this.pixels, fichier);
	}

	/**
	 * Met à jour le tableau de pixels en appliquant une transformation d'image.
	 * 
	 * @param t transformation à appliquer
	 * @return vrai si la transformation a pu être appliquée, faux sinon
	 */
	public boolean applique(Transformation t) {
		// TODO EXERCICE 1 : à compléter...
		return false; // <- TODO résultat à adapter
	}

}
